<div class="container mt-4">
    <h2>Paramètres</h2>

    <form id="settingsForm">
        <input type="hidden" id="setting_id" name="id">
        <div class="row mb-3">
            <div class="col">
                <input type="text" name="keyname" id="keyname" class="form-control" placeholder="Clé">
            </div>
            <div class="col">
                <input type="text" name="label" id="label" class="form-control" placeholder="Libellé">
            </div>
            <div class="col">
                <input type="text" name="value" id="value" class="form-control" placeholder="Valeur">
            </div>
            <div class="col">
                <button type="submit" class="btn btn-primary">Enregistrer</button>
            </div>
        </div>
    </form>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Clé</th>
                <th>Libellé</th>
                <th>Valeur</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($settings as $s): ?>
                <tr>
                    <td><?= htmlspecialchars($s['keyname']) ?></td>
                    <td><?= htmlspecialchars($s['label']) ?></td>
                    <td><?= htmlspecialchars($s['value']) ?></td>
                    <td>
                        <button class="btn btn-sm btn-warning edit-btn"
                            data-id="<?= $s['id'] ?>"
                            data-keyname="<?= htmlspecialchars($s['keyname']) ?>"
                            data-label="<?= htmlspecialchars($s['label']) ?>"
                            data-value="<?= htmlspecialchars($s['value']) ?>">Modifier</button>
                        <button class="btn btn-sm btn-danger delete-btn"
                            data-id="<?= $s['id'] ?>">Supprimer</button>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<div id="toast-container" class="toast-container position-fixed bottom-0 end-0 p-3"></div>
<script src="/public/assets/js/settings.js"></script>
