<div class="container mt-4">
    <h2>Cotisations sociales</h2>
    <a href="/social-settings/create" class="btn btn-success mb-3">+ Ajouter</a>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Id</th>
                <th>Clé</th>
                <th>Libellé</th>
                <th>Taux</th>
                <th>Base</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($sociales as $s): ?>
            <tr>
                <td><?= $s['id'] ?></td>
                <td><?= htmlspecialchars($s['keyname']) ?></td>
                <td><?= htmlspecialchars($s['label']) ?></td>
                <td><?= number_format($s['rate'], 2, ',', ' ') ?></td>
                <td><?= number_format($s['gross_base'], 2, ',', ' ') ?> €</td>
                <td>
                    <a href="/public/social-settings/edit?id=<?= $s['id'] ?>" class="btn btn-primary btn-sm">Modifier</a>
                    <form method="POST" action="/public/social-settings/delete" style="display:inline">
                        <input type="hidden" name="id" value="<?= $s['id'] ?>">
                        <button type="submit" class="btn btn-danger btn-sm">Supprimer</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>