<?php
require_once __DIR__ . '/../../models/Database.php';
use Models\Database;
// Initialize the database connection
$pdo = Database::getInstance()->getConnection();
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Handle form submissions for add/update/delete actions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add'])) {
        // Add new social setting
        $stmt = $pdo->prepare("INSERT INTO social_settings (keyname, label, rate, gross_base) VALUES (?, ?, ?, ?)");
        $stmt->execute([$_POST['keyname'], $_POST['value'], $_POST['rate'], $_POST['gross_base']]);
    }

    if (isset($_POST['update'])) {
        // Update existing social setting
        $stmt = $pdo->prepare("UPDATE social_settings SET keyname = ?, label = ?, rate = ?, gross_base = ? WHERE id = ?");
        $stmt->execute([$_POST['keyname'], $_POST['value'], $_POST['rate'], $_POST['gross_base'], $_POST['id']]);
    }

    if (isset($_POST['delete'])) {
        // Delete social setting
        $stmt = $pdo->prepare("DELETE FROM social_settings WHERE id = ?");
        $stmt->execute([$_POST['id']]);
    }
}

// Fetch all social settings
$stmt = $pdo->query("SELECT * FROM social_settings");
$social_settings = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Paramètres Sociaux</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://salaires.advancedgroup.lu/assets/css/dashboard.css">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f7fc;
            margin: 0;
            padding: 0;
            color: #333;
        }

        h1, h2 {
            text-align: center;
            color: #3b3f50;
        }

        .container {
            max-width: 900px;
            margin: 20px auto;
            background-color: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
        }

        .form-group input {
            width: 100%;
            padding: 12px;
            font-size: 16px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }

        .form-group input[type="number"] {
            -moz-appearance: textfield;
        }

        .button {
            background-color: #007bff;
            color: white;
            padding: 12px 24px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            width: 100%;
            text-align: center;
        }

        .button:hover {
            background-color: #0056b3;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 30px;
        }

        table th, table td {
            padding: 12px;
            text-align: left;
            border: 1px solid #ddd;
        }

        table th {
            background-color: #007bff;
            color: white;
        }

        .action-buttons button {
            background-color: #28a745;
            color: white;
            padding: 8px 16px 8px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            margin-bottom: 8px;
        }

        .action-buttons button.delete {
            background-color: #dc3545;
        }

        .action-buttons button:hover {
            opacity: 0.8;
        }
    </style>
</head>
<body>

<div class="container">
    <h1>Gestion des Paramètres Sociaux</h1>

    <!-- Form to Add a new social setting -->
    <h2>Ajouter un Paramètre Social</h2>
    <form method="POST">
        <div class="form-group">
            <label for="keyname">Nom du paramètre :</label>
            <input type="text" name="keyname" required>
        </div>

        <div class="form-group">
            <label for="value">Valeur :</label>
            <input type="text" name="value" required>
        </div>

        <div class="form-group">
            <label for="rate">Taux :</label>
            <input type="number" name="rate" step="0.01" required>
        </div>

        <div class="form-group">
            <label for="gross_base">Base brute :</label>
            <input type="number" name="gross_base" step="0.01" required>
        </div>

        <button type="submit" name="add" class="button">Ajouter</button>
    </form>

    <!-- Table to display existing social settings -->
    <h2>Paramètres Sociaux Actuels</h2>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Nom</th>
                <th>Valeur</th>
                <th>Taux</th>
                <th>Base brute</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($social_settings as $setting): ?>
                <tr>
                    <form method="POST">
                        <td><?php echo $setting['id']; ?></td>
                        <td><input type="text" name="keyname" value="<?php echo $setting['keyname']; ?>" required></td>
                        <td><input type="text" name="value" value="<?php echo $setting['label']; ?>" required></td>
                        <td><input type="number" step="0.01" name="rate" value="<?php echo $setting['rate']; ?>" required></td>
                        <td><input type="number" step="0.01" name="gross_base" value="<?php echo $setting['gross_base']; ?>" required></td>
                        <td class="action-buttons">
                            <button type="submit" name="update" value="<?php echo $setting['id']; ?>" >Enregistrer</button>
                            <button type="submit" name="delete" value="<?php echo $setting['id']; ?>" class="delete">Supprimer</button>
                        </td>
                        <td><input type="number" step="0.01" name="id" value="<?php echo $setting['id']; ?>" hidden></td>
                    </form>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

</body>
</html>