<div class="container mt-4">
    <h2>Abattements</h2>
    <a href="/benefits/create" class="btn btn-success mb-3">+ Ajouter</a>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Employé</th>
                <th>Clé</th>
                <th>Libellé</th>
                <th>Montant</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($moderations as $m): ?>
            <tr>
                <td><?= htmlspecialchars($m['employee_name']) ?></td>
                <td><?= htmlspecialchars($m['keyname']) ?></td>
                <td><?= htmlspecialchars($m['label']) ?></td>
                <td><?= number_format($m['amount'], 2, ',', ' ') ?> €</td>
                <td>
                    <a href="/public/moderation-settings/edit?id=<?= $m['id'] ?>" class="btn btn-primary btn-sm">Modifier</a>
                    <form method="POST" action="/public/moderation-settings/delete" style="display:inline">
                        <input type="hidden" name="id" value="<?= $m['id'] ?>">
                        <button type="submit" class="btn btn-danger btn-sm">Supprimer</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>