<div class="container mt-4">
    <h2><?= isset($moderation) ? 'Modifier' : 'Ajouter' ?> un abattement</h2>
    <form method="POST" action="<?= isset($moderation) ? '/public/moderation-settings/update' : '/public/moderation-settings/store' ?>">
        <?php if (isset($moderation)): ?>
            <input type="hidden" name="id" value="<?= $moderation['id'] ?>">
        <?php endif; ?>

        <div class="mb-3">
            <label>Employé</label>
            <select name="employee_id" class="form-select">
                <?php foreach ($employees as $e): ?>
                <option value="<?= $e['id'] ?>" <?= isset($moderation) && $moderation['employee_id'] == $e['id'] ? 'selected' : '' ?>>
                    <?= htmlspecialchars($e['name']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="mb-3">
            <label>Clé</label>
            <input type="text" id="keyname" name="keyname" class="form-control" value="<?= htmlspecialchars($moderation['keyname'] ?? '') ?>" required>
        </div>

        <div class="mb-3">
            <label>Libellé</label>
            <input type="text" id="label" name="label" class="form-control" value="<?= htmlspecialchars($moderation['label'] ?? '') ?>" required>
        </div>

        <div class="mb-3">
            <label>Montant (€)</label>
            <input type="number" step="0.01" id="amount" name="amount" class="form-control" value="<?= htmlspecialchars($moderation['amount'] ?? '') ?>" required>
        </div>

        <button type="submit" class="btn btn-primary"><?= isset($moderation) ? 'Mettre à jour' : 'Enregistrer' ?></button>
        <button type="cancel" class="btn btn-secondary">Annuler</button>
    </form>
</div>