<?php
require_once __DIR__ . '/../../models/Database.php';
use Models\Database;

$pdo = Database::getInstance()->getConnection();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("
        INSERT INTO employees (
            first_name, last_name, contract_start, contract_end,
            matricule, date_entree, classe, taux_impot, indice, date_sortie,
            date_anciennete, statut_fiscal, profession, gross_salary,
            heures_semaine, heures_mois, iban, bic_code, bank, status
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    $stmt->execute([
        $_POST['first_name'],
        $_POST['last_name'],
        $_POST['contract_start'],
        $_POST['contract_end'] ?: null,
        $_POST['matricule'],
        $_POST['date_entree'],
        $_POST['classe'],
        $_POST['taux_impot'],
        $_POST['indice'] ?: null,
        $_POST['date_sortie'] ?: null,
        $_POST['date_anciennete'] ?: null,
        $_POST['statut_fiscal'] ?: null,
        $_POST['profession'] ?: null,
        $_POST['gross_salary'],
        $_POST['heures_semaine'] ?: null,
        $_POST['heures_mois'] ?: null,
        $_POST['iban'] ?: null,
        $_POST['bic_code'] ?: null,
        $_POST['bank'] ?: null,
        $_POST['status'] ?? 'actif'
    ]);

    header("Location: /employees");
    exit;
} else {
    // echo "Méthode non autorisée : " . $_SERVER['REQUEST_METHOD'];
}
?>

<div class="container mt-4">
  <h2>Ajouter un nouvel employé</h2>
  <form method="POST"><!-- action="/employees/store" -->
    <div class="row">
      <div class="col-md-6 mb-3">
        <label>Prénom *</label>
        <input type="text" name="first_name" class="form-control" required>
      </div>
      <div class="col-md-6 mb-3">
        <label>Nom *</label>
        <input type="text" name="last_name" class="form-control" required>
      </div>
      <div class="col-md-6 mb-3">
        <label>Date de début du contrat *</label>
        <input type="date" name="contract_start" class="form-control" required>
      </div>
      <div class="col-md-6 mb-3">
        <label>Date de fin du contrat</label>
        <input type="date" name="contract_end" class="form-control">
      </div>
      <div class="col-md-6 mb-3">
        <label>Matricule *</label>
        <input type="text" name="matricule" class="form-control" required>
      </div>
      <div class="col-md-6 mb-3">
        <label>Date d'entrée *</label>
        <input type="date" name="date_entree" class="form-control" required>
      </div>
      <div class="col-md-6 mb-3">
        <label>Classe d'impôt</label>
        <input type="number" step="0.01" name="classe" class="form-control" required>
      </div>
      <div class="col-md-6 mb-3">
        <label>Taux d'imposition (%) *</label>
        <input type="number" step="0.01" name="taux_impot" class="form-control" required>
      </div>
      <div class="col-md-6 mb-3">
        <label>Indice</label>
        <input type="text" name="indice" class="form-control">
      </div>
      <div class="col-md-6 mb-3">
        <label>Date de sortie</label>
        <input type="date" name="date_sortie" class="form-control">
      </div>
      <div class="col-md-6 mb-3">
        <label>Date d'ancienneté</label>
        <input type="date" name="date_anciennete" class="form-control">
      </div>
      <div class="col-md-6 mb-3">
        <label>Statut fiscal</label>
        <input type="text" name="statut_fiscal" class="form-control">
      </div>
      <div class="col-md-6 mb-3">
        <label>Profession</label>
        <input type="text" name="profession" class="form-control">
      </div>
      <div class="col-md-6 mb-3">
        <label>Salaire brut (€) *</label>
        <input type="number" step="0.01" name="gross_salary" class="form-control" required>
      </div>
      <div class="col-md-6 mb-3">
        <label>Heures par semaine</label>
        <input type="number" step="0.01" name="heures_semaine" class="form-control">
      </div>
      <div class="col-md-6 mb-3">
        <label>Heures par mois</label>
        <input type="number" step="0.01" name="heures_mois" class="form-control">
      </div>
      <div class="col-md-6 mb-3">
        <label>IBAN</label>
        <input type="text" name="iban" class="form-control">
      </div>
      <div class="col-md-6 mb-3">
        <label>BIC</label>
        <input type="text" name="bic_code" class="form-control">
      </div>
      <div class="col-md-6 mb-3">
        <label>Banque</label>
        <input type="text" name="bank" class="form-control">
      </div>
      <div class="col-md-6 mb-3">
        <label>Statut</label>
        <select name="status" class="form-select">
          <option value="actif" selected>Actif</option>
          <option value="inactif">Inactif</option>
        </select>
      </div>
    </div>
    <!-- <button type="submit" class="btn btn-success">Enregistrer</button> -->
    <div class="d-flex align-items-center gap-2">
        <input type="submit" value="Enregistrer" class="btn btn-success">
        <a href="/public/employees/view" class="btn btn-secondary">← Retour</a>
    </div>
  </form>
</div>
