<?php
//namespace Utils;

//require_once __DIR__ . '/../vendor/autoload.php';
use TCPDF;

class MyPdf extends TCPDF
{
    // Pied de page
    public function Footer()
    {
        $this->SetY(-20);
        $this->SetDrawColor(180, 180, 180);
        $this->Line(10, $this->GetY(), 200, $this->GetY());

        $this->SetY(-15);
        $this->SetFont('dejavusans', 'I', 8);
        $this->SetTextColor(100, 100, 100);

        $smlogoPath = 'assets/images/smlogo.png';
        if (file_exists($smlogoPath)) {
            $this->Image($smlogoPath, 10, $this->GetY(), 8);
        }
        // Texte centré
        $this->Cell(0, 5, 'ACSPaye © - Bulletin généré automatiquement par ADVANCED Corporate Services', 0, 1, 'C');
        // Pagination
        //$this->Cell(0, 5, 'Page ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'C');
    }

    // En-tête avec logo et informations
    public function Header()
    {
        // Logo
        //$logoPath = __DIR__ . '/../assets/images/acs_logo.png';
        $logoPath = 'assets/images/logo.png';
        if (file_exists($logoPath)) {
            $this->Image($logoPath, 10, 10, 50);
        }

        // Texte entreprise
        $this->SetY(10);
        $this->SetFont('dejavusans', 'B', 11);
        $this->SetTextColor(50, 50, 50);
        $this->Cell(0, 5, 'ADVANCED Corporate Services SARL', 0, 1, 'C');
        $this->SetFont('dejavusans', '', 9);
        $this->Cell(0, 5, '32 rue du Curé - L-1368 Luxembourg', 0, 1, 'C');
        $this->Ln(5);
    }
}