/**
 * Script principal de l'application
 * Gère les interactions du dashboard et des fiches de paie
 */

document.addEventListener('DOMContentLoaded', function() {
    // =====================
    // 1. INITIALISATION
    // =====================
    const sidebar = document.querySelector('.sidebar');
    const mobileMenuBtn = document.getElementById('mobile-menu-btn');
    
    // =====================
    // 2. TOGGLES DU MENU
    // =====================
    if (mobileMenuBtn) {
        mobileMenuBtn.addEventListener('click', function() {
            sidebar.classList.toggle('active');
            this.classList.toggle('active');
        });
    }

    // =====================
    // 3. GRAPHIQUES
    // =====================
    const initCharts = () => {
        // Graphique des paies mensuelles (exemple)
        const payslipsCtx = document.getElementById('payslips-chart');
        if (payslipsCtx) {
            new Chart(payslipsCtx, {
                type: 'bar',
                data: {
                    labels: ['Jan', 'Fév', 'Mar', 'Avr', 'Mai', 'Jun'],
                    datasets: [{
                        label: 'Fiches de paie',
                        data: [12, 19, 15, 24, 22, 18],
                        backgroundColor: 'rgba(54, 162, 235, 0.7)'
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: { display: false }
                    }
                }
            });
        }

        // Graphique circulaire des départements
        const departmentsCtx = document.getElementById('departments-chart');
        if (departmentsCtx) {
            new Chart(departmentsCtx, {
                type: 'pie',
                data: {
                    labels: ['Comptabilité', 'RH', 'IT', 'Direction'],
                    datasets: [{
                        data: [15, 12, 8, 5],
                        backgroundColor: [
                            'rgba(255, 99, 132, 0.7)',
                            'rgba(75, 192, 192, 0.7)',
                            'rgba(255, 206, 86, 0.7)',
                            'rgba(153, 102, 255, 0.7)'
                        ]
                    }]
                }
            });
        }
    };

    // =====================
    // 4. GESTION DES DONNÉES
    // =====================
    const fetchDashboardData = async () => {
        try {
            const response = await fetch('/api/dashboard');
            if (!response.ok) throw new Error('Erreur réseau');
            return await response.json();
        } catch (error) {
            console.error('Erreur:', error);
            showAlert('Impossible de charger les données', 'danger');
        }
    };

    // =====================
    // 5. UTILITAIRES
    // =====================
    const showAlert = (message, type = 'success') => {
        const alert = document.createElement('div');
        alert.className = `alert alert-${type} alert-dismissible fade show`;
        alert.innerHTML = `
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;
        document.getElementById('alerts-container').appendChild(alert);
        
        setTimeout(() => alert.remove(), 5000);
    };

    // Initialisation
    if (typeof Chart !== 'undefined') initCharts();
    
    // Exemple d'utilisation
    // fetchDashboardData().then(data => updateUI(data));
});