<?php
require_once 'Database.php';

class ModerationSetting {
    private $db;

    public function __construct() {
        $this->db = (new Database())->connect();
    }

    public function findByEmployee($employeeId) {
        $stmt = $this->db->prepare("
            SELECT * FROM moderation_settings 
            WHERE employee_id = :employee_id
        ");
        $stmt->bindParam(':employee_id', $employeeId, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function updateForEmployee($employeeId, $settings) {
        $this->db->beginTransaction();
        
        try {
            // Supprimer les anciens paramètres
            $stmt = $this->db->prepare("
                DELETE FROM moderation_settings 
                WHERE employee_id = :employee_id
            ");
            $stmt->bindParam(':employee_id', $employeeId, PDO::PARAM_INT);
            $stmt->execute();

            // Insérer les nouveaux
            foreach ($settings as $setting) {
                $stmt = $this->db->prepare("
                    INSERT INTO moderation_settings (
                        employee_id, keyname, value, amount
                    ) VALUES (
                        :employee_id, :keyname, :value, :amount
                    )
                ");
                $stmt->execute([
                    ':employee_id' => $employeeId,
                    ':keyname' => $setting['keyname'],
                    ':value' => $setting['value'],
                    ':amount' => $setting['amount']
                ]);
            }

            $this->db->commit();
            return true;
        } catch (PDOException $e) {
            $this->db->rollBack();
            error_log("Error updating moderation settings: ".$e->getMessage());
            return false;
        }
    }
}
?>