<?php
namespace Controllers;
require_once __DIR__ . '/../models/Setting.php';
require_once __DIR__ . '/../utils/logger.php';
use Models\Setting;  // Import Setting
use Utils\Logger;

class SettingsController {
    public function index() {
        $settings = Setting::all();
        $this->loadInDashboard('index.php', ['settings' => $settings]);
        // require_once __DIR__ . '/../views/settings/index.php';
    }

    public function create() {
        //require_once __DIR__ . '/../views/settings/create.php';
        $this->loadInDashboard('create.php');
    }

    public function store() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'keyname' => $_POST['keyname'],
                'label' => $_POST['label'],
                'value' => $_POST['value']
            ];

            if (Setting::create($data)) {
                $_SESSION['message'] = 'Paramètre créé avec succès';
                header('Location: /settings');
                exit;
            }
        }
    }

    public function edit($id) {
        $setting = Setting::find($id);
        
        if (!$setting) {
            $_SESSION['error'] = 'Paramètre introuvable';
            header('Location: /settings');
            exit;
        }

        // Debug : vérifiez les données avant envoi à la vue
        error_log(print_r($setting, true));
        
        $this->loadInDashboard('edit.php', ['setting' => $setting]);
    }

    //public function update($id) {
    public function update() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id'])) {
            $id = $_POST['id'];

            /* Logger::db_log("Tentative mise à jour paramètre", [
                'id' => $id,
                'post_data' => $_POST,
                'keyname' => $_POST['keyname'],
                'label' => $_POST['label'],
                'value' => $_POST['value'],
                'ip' => $_SERVER['REMOTE_ADDR']
            ]); */
            //custom_log("Tentative de mise à jour", ['id' => $id, 'post' => $_POST]);
            $data = [
                'id' => $id,
                'keyname' => $_POST['keyname'],
                'label' => $_POST['label'],
                'value' => $_POST['value']
            ];

            if (Setting::update($id, $data)) {
                $_SESSION['message'] = 'Paramètre mis à jour avec succès';
                header('Location: /settings');
                exit;
            } else {
                $_SESSION['error'] = 'Échec de la mise à jour';
                header('Location: /settings/edit?id=' . $id);
                exit;
            }
        }
    }


    public function delete($id) {
        if (Setting::delete($id)) {
            $_SESSION['message'] = 'Paramètre supprimé avec succès';
        } else {
            $_SESSION['error'] = 'Erreur lors de la suppression';
        }
        header('Location: /settings');
        exit;
    }

    private function loadInDashboard($viewFile, $data = []) {
        extract($data);
        $viewPath = __DIR__ . '/../views/settings/' . $viewFile;
        if (!file_exists($viewPath)) {
            throw new \Exception("Vue $viewFile introuvable");
        }
        $view = $viewPath;
        require __DIR__ . '/../views/dashboard.php';
    }
}