<?php include 'header.php'; ?>

<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="h3 mb-0 text-gray-800">Gestion des Utilisateurs</h1>
            <a href="/users/create" class="btn btn-primary float-right">
                <i class="fas fa-plus"></i> Nouvel utilisateur
            </a>
        </div>
    </div>

    <?php if (isset($_SESSION['flash'])): ?>
        <div class="alert alert-<?= $_SESSION['flash']['type'] ?>">
            <?php 
                if (is_array($_SESSION['flash']['message'])) {
                    echo '<ul>';
                    foreach ($_SESSION['flash']['message'] as $msg) {
                        echo '<li>'.$msg.'</li>';
                    }
                    echo '</ul>';
                } else {
                    echo $_SESSION['flash']['message'];
                }
                unset($_SESSION['flash']); 
            ?>
        </div>
    <?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Liste des utilisateurs</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="usersTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Nom d'utilisateur</th>
                            <th>Email</th>
                            <th>Rôle</th>
                            <th>Créé le</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users as $user): ?>
                        <tr>
                            <td><?= htmlspecialchars($user['id']) ?></td>
                            <td><?= htmlspecialchars($user['username']) ?></td>
                            <td><?= htmlspecialchars($user['email']) ?></td>
                            <td>
                                <span class="badge badge-<?= 
                                    $user['user_roles'] === 'admin' ? 'danger' : 
                                    ($user['user_roles'] === 'chef_comptable' ? 'warning' : 'info') 
                                ?>">
                                    <?= ucfirst(str_replace('_', ' ', $user['user_roles'])) ?>
                                </span>
                            </td>
                            <td><?= date('d/m/Y H:i', strtotime($user['created_at'])) ?></td>
                            <td>
                                <a href="/users/<?= $user['id'] ?>/edit" class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="/users/<?= $user['id'] ?>/delete" method="POST" class="d-inline">
                                    <input type="hidden" name="csrf_token" value="<?= Auth::generateCsrfToken() ?>">
                                    <button type="submit" class="btn btn-sm btn-danger" 
                                        onclick="return confirm('Êtes-vous sûr de vouloir supprimer cet utilisateur ?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<script>
$(document).ready(function() {
    $('#usersTable').DataTable({
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.20/i18n/French.json"
        },
        "columnDefs": [
            { "orderable": false, "targets": [5] }
        ]
    });
});
</script>