<?php include 'header.php'; ?>

<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="h3 mb-0 text-gray-800">Créer un nouvel utilisateur</h1>
            <a href="/users" class="btn btn-secondary float-right">
                <i class="fas fa-arrow-left"></i> Retour
            </a>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Informations de l'utilisateur</h6>
        </div>
        <div class="card-body">
            <form action="/users/create" method="POST">
                <input type="hidden" name="csrf_token" value="<?= Auth::generateCsrfToken() ?>">
                
                <div class="form-group row">
                    <label for="username" class="col-sm-3 col-form-label">Nom d'utilisateur *</label>
                    <div class="col-sm-9">
                        <input type="text" class="form-control" id="username" name="username" 
                            value="<?= htmlspecialchars($_POST['username'] ?? '') ?>" required>
                    </div>
                </div>
                
                <div class="form-group row">
                    <label for="email" class="col-sm-3 col-form-label">Email *</label>
                    <div class="col-sm-9">
                        <input type="email" class="form-control" id="email" name="email" 
                            value="<?= htmlspecialchars($_POST['email'] ?? '') ?>" required>
                    </div>
                </div>
                
                <div class="form-group row">
                    <label for="password" class="col-sm-3 col-form-label">Mot de passe *</label>
                    <div class="col-sm-9">
                        <input type="password" class="form-control" id="password" name="password" required>
                        <small class="form-text text-muted">Minimum 8 caractères</small>
                    </div>
                </div>
                
                <div class="form-group row">
                    <label for="user_roles" class="col-sm-3 col-form-label">Rôle *</label>
                    <div class="col-sm-9">
                        <select class="form-control" id="user_roles" name="user_roles" required>
                            <option value="">-- Sélectionnez un rôle --</option>
                            <option value="admin" <?= isset($_POST['user_roles']) && $_POST['user_roles'] === 'admin' ? 'selected' : '' ?>>Administrateur</option>
                            <option value="chef_comptable" <?= isset($_POST['user_roles']) && $_POST['user_roles'] === 'chef_comptable' ? 'selected' : '' ?>>Chef comptable</option>
                            <option value="comptable" <?= isset($_POST['user_roles']) && $_POST['user_roles'] === 'comptable' ? 'selected' : '' ?>>Comptable</option>
                        </select>
                    </div>
                </div>
                
                <div class="form-group row">
                    <div class="col-sm-9 offset-sm-3">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Enregistrer
                        </button>
                        <a href="/users" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Annuler
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>