<?php
namespace Utils;

require_once __DIR__ . '/../models/Database.php';
use Models\Database;
use PDO;

class Logger {
    public static function db_log($message, $context = null) {
        $pdo = Database::getInstance()->getConnection();
        
        $stmt = $pdo->prepare("
            INSERT INTO debug_logs 
            (timestamp, message, context) 
            VALUES (NOW(), ?, ?)
        ");
        
        $stmt->execute([
            $message,
            json_encode($context, JSON_PRETTY_PRINT)
        ]);
        
        return $pdo->lastInsertId();
    }
}