<?php
namespace Controllers;
/**
 * AuthController - Gestion de l'authentification
 * Chemin : /home/advanck/salaires/controllers/AuthController.php
 */
/* ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
ini_set('log_errors', '1');
ini_set('error_log', __DIR__.'/../logs/error.log'); */
// Chargement des dépendances
require_once __DIR__.'/../utils/Auth.php';
require_once __DIR__.'/../models/User.php';

use Utils\Auth;
use Models\User;

class AuthController
{
    /**
     * Affiche le formulaire de connexion et gère la soumission
     */
    public function login()
    {
        $file = fopen(__DIR__.'/../logs/auth.log', 'a');
        // Vérification simple
        if (!file_exists(__DIR__.'/../views/auth/login.php')) {
            throw new \Exception('Vue login introuvable');
        }
        fwrite($file,"REQUEST METHOD : " . $_SERVER['REQUEST_METHOD'] . "\n");
        // Traitement du formulaire
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $username = trim($_POST['username'] ?? '');
            $password = $_POST['password'] ?? '';
            
            fwrite($file, "Tentative de connexion pour l'utilisateur : ". $username . " avec mot de passe : " .$password . "\n");
            fclose($file);
            try {
                // Validation
                if (empty($username) || empty($password)) {
                    throw new \Exception("Tous les champs sont requis");
                }
                $file = fopen(__DIR__.'/../logs/auth.log', 'a');
                fwrite($file,"Cette ligne tente de créer un nouvel objet de la classe User, puis appelle la méthode findByUsername($username) pour récupérer un utilisateur à partir de la base de données." ."\n");
                // Authentification
                $user = (new User())->findByUsername($username);
                fwrite($file, "Utilisateur trouvé : " . ($user ? 'oui' : 'non') . "\n");
                fwrite($file, "Mot de passe fourni : " . (!empty($password) ? 'oui' : 'non') . "\n");
                fwrite($file, "Utilisateur : " . print_r($user) . "\n");
                if (!$user || !password_verify($password, $user['password'])) {
                    throw new \Exception("Identifiants incorrects");
                }
                fclose($file);
                // Connexion réussie
                Auth::login($user); // Appel de la méthode de connexion
                header('Location: /public/dashboard');
                exit;

            } catch (Exception $e) {
                // Gestion des erreurs
                $error = $e->getMessage();
                $file = fopen(__DIR__.'/../logs/auth.log', 'a');
                fwrite($file,"Error line 58 : " . $error . "\n");
                fclose($file);
                error_log("Erreur de connexion : " . $error);
            }
        }

        // Affichage de la vue
        $viewPath = __DIR__.'/../views/auth/login.php';
        if (!file_exists($viewPath)) {
            die("Erreur : Fichier vue introuvable ($viewPath)");
        }
        
        require $viewPath;
        //exit;
    }

    /**
     * Déconnecte l'utilisateur
     */
    public function logout() {
        // Logique de déconnexion
        Auth::logout();
        
        // Affichage de la vue de déconnexion
        require_once __DIR__.'/../views/auth/logout.php';
    }
}

// Test d'intégrité de la classe
if (basename(__FILE__) == 'AuthController.php') {
    new AuthController();
    error_log("AuthController chargé avec succès");
}