<?php
$_SESSION['csrf_token'] = bin2hex(random_bytes(32));
?>
<div class="container mt-4">
    <h2>Modifier le paramètre</h2>
    
    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
    <?php endif; ?>

    <form action="/public/settings/update" method="POST" id="settingForm">
    <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
    <input type="hidden" id="id" name="id" value="<?= $setting['id'] ?>">
    
    <div class="mb-3">
        <label class="form-label">Clé technique</label>
        <input type="text" class="form-control" id="keyname" name="keyname" 
               value="<?= htmlspecialchars($setting['keyname'] ?? '') ?>" required>
    </div>
    
    <div class="mb-3">
        <label class="form-label">Libellé</label>
        <input type="text" class="form-control" id="label" name="label" 
               value="<?= htmlspecialchars($setting['label'] ?? '') ?>" required>
    </div>
    
    <div class="mb-3">
        <label class="form-label">Valeur</label>
        <input type="text" class="form-control" id="value" name="value" 
               value="<?= htmlspecialchars($setting['value'] ?? '') ?>" required>
    </div>
    
    <button type="submit" class="btn btn-primary">Mettre à jour</button>
</form>
</div>
<script>
document.getElementById('settingForm').addEventListener('submit', function(e) {
    const formData = new FormData(this);
    console.log('Données à envoyer:', Object.fromEntries(formData));

});
</script>