<?php
require_once __DIR__ . '/../../models/Database.php';
use Models\Database;

$pdo = Database::getInstance()->getConnection();

$id = $_GET['id'] ?? null;

if (!$id) {
    echo "ID manquant.";
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM employees WHERE id = ?");
$stmt->execute([$id]);
$employee = $stmt->fetch();

if (!$employee) {
    echo "Employé introuvable.";
    exit;
}

$id = $_GET['id'] ?? null;

if (!$id) {
    echo "ID manquant.";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
      $stmt = $pdo->prepare("
          UPDATE employees SET
              first_name = ?, last_name = ?, contract_start = ?, contract_end = ?, matricule = ?,
              date_entree = ?, taux_impot = ?, indice = ?, date_sortie = ?, date_anciennete = ?,
              statut_fiscal = ?, profession = ?, gross_salary = ?, cis = ?, co2 = ?, heures_semaine = ?, heures_mois = ?,
              iban = ?, bic_code = ?, bank = ?, status = ?
          WHERE id = ?
      ");

      $stmt->execute([
          $_POST['first_name'], $_POST['last_name'], $_POST['contract_start'], $_POST['contract_end'] ?: null,
          $_POST['matricule'], $_POST['date_entree'], $_POST['taux_impot'], $_POST['indice'] ?: null,
          $_POST['date_sortie'] ?: null, $_POST['date_anciennete'] ?: null, $_POST['statut_fiscal'] ?: null,
          $_POST['profession'] ?: null, $_POST['gross_salary'], $_POST['cis'], $_POST['co2'], $_POST['heures_semaine'] ?: null,
          $_POST['heures_mois'] ?: null, $_POST['iban'] ?: null, $_POST['bic_code'] ?: null,
          $_POST['bank'] ?: null, $_POST['status'] ?? 'actif', $id
      ]);

      header("Location: /employees");
      exit;
  } /* else {
      echo "Méthode non autorisée : " . $_SERVER['REQUEST_METHOD'];
} */
?>

<div class="container mt-4">
  <h2>Modifier l'employé : <?= htmlspecialchars($employee['first_name'] . ' ' . $employee['last_name']) ?></h2>
  <form method="POST">
    <div class="row">
<?php
$fields = [
    'first_name' => 'Prénom', 'last_name' => 'Nom', 'contract_start' => 'Début contrat',
    'contract_end' => 'Fin contrat', 'matricule' => 'Matricule', 'date_entree' => 'Date d\'entrée',
    'date_sortie' => 'Date de sortie', 'date_anciennete' => 'Date d\'ancienneté', 'profession' => 'Profession', 'statut_fiscal' => 'Statut fiscal', 'gross_salary' => 'Salaire brut', 
    'indice' => 'Indice', 'heures_semaine' => 'Heures/semaine', 'heures_mois' => 'Heures/mois', 'taux_impot' => 'Taux d\'imposition', 'cis' => 'Crédit d\'impôt salarié', 'co2' => 'Crédit d\'impôt climat', 
    'iban' => 'IBAN', 'bic_code' => 'BIC', 'bank' => 'Banque'
];

foreach ($fields as $key => $label): ?>
      <div class="col-md-6 mb-3">
        <label for="<?= $key ?>" class="form-label"><?= $label ?></label>
        <input type="<?= (strpos($key, 'date') !== false || strpos($key, 'contract') !== false) ? 'date' : 'text' ?>"
               class="form-control"
               name="<?= $key ?>"
               value="<?= htmlspecialchars($employee[$key] ?? '') ?>">
      </div>
<?php endforeach; ?>
      <div class="col-md-6 mb-3">
        <label for="status" class="form-label">Statut</label>
        <select class="form-select" name="status">
          <option value="actif" <?= $employee['status'] === 'actif' ? 'selected' : '' ?>>Actif</option>
          <option value="inactif" <?= $employee['status'] === 'inactif' ? 'selected' : '' ?>>Inactif</option>
        </select>
      </div>
    </div>
    <button type="submit" class="btn btn-primary">Mettre à jour</button>
  </form>
</div>
