<div class="container mt-4">
    <h2>Avantages en nature</h2>
    <a href="/benefits/create" class="btn btn-success mb-3">+ Ajouter</a>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Employé</th>
                <th>Clé</th>
                <th>Libellé</th>
                <th>Montant</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($benefits as $b): ?>
            <tr>
                <td><?= htmlspecialchars($b['employee_name']) ?></td>
                <td><?= htmlspecialchars($b['keyname']) ?></td>
                <td><?= htmlspecialchars($b['label']) ?></td>
                <td><?= number_format($b['amount'], 2, ',', ' ') ?> €</td>
                <td>
                    <a href="/benefits/edit?id=<?= $b['id'] ?>" class="btn btn-primary btn-sm">Modifier</a>
                    <form method="POST" action="/benefits/delete" style="display:inline">
                        <input type="hidden" name="id" value="<?= $b['id'] ?>">
                        <button type="submit" class="btn btn-danger btn-sm">Supprimer</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>