<div class="container mt-4">
    <h2><?= isset($benefit) ? 'Modifier' : 'Ajouter' ?> un avantage en nature</h2>
    <form method="POST" action="<?= isset($benefit) ? '/public/benefits/update' : '/public/benefits/store' ?>">
        <?php if (isset($benefit)): ?>
            <input type="hidden" name="id" value="<?= $benefit['id'] ?>">
        <?php endif; ?>

        <div class="mb-3">
            <label>Employé</label>
            <select name="employee_id" class="form-select">
                <?php foreach ($employees as $e): ?>
                <option value="<?= $e['id'] ?>" <?= isset($benefit) && $benefit['employee_id'] == $e['id'] ? 'selected' : '' ?>>
                    <?= htmlspecialchars($e['name']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="mb-3">
            <label>Clé</label>
            <input type="text" id="keyname" name="keyname" class="form-control" value="<?= htmlspecialchars($benefit['keyname'] ?? '') ?>" required>
        </div>

        <div class="mb-3">
            <label>Libellé</label>
            <input type="text" id="label" name="label" class="form-control" value="<?= htmlspecialchars($benefit['label'] ?? '') ?>" required>
        </div>

        <div class="mb-3">
            <label>Montant (€)</label>
            <input type="number" step="0.01" id="amount" name="amount" class="form-control" value="<?= htmlspecialchars($benefit['amount'] ?? '') ?>" required>
        </div>

        <button type="submit" class="btn btn-primary"><?= isset($benefit) ? 'Mettre à jour' : 'Enregistrer' ?></button>
    </form>
</div>