<?php
namespace Utils;

require_once __DIR__ . '/../vendor/autoload.php';
//require_once '/home/advanck/salaires/utils/tcpdf/tcpdf.php'; // si inclusion manuelle
use TCPDF;

class PdfGenerator {
    public function generatePayslip($payslipData) {
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        
        // Configuration du document
        $pdf->SetCreator('ADVANCED Corporate Services');
        $pdf->SetAuthor('Service Paie');
        $pdf->SetTitle('Bulletin de salaire - ' . $payslipData['employee_name']);
        $pdf->SetSubject('Bulletin de salaire');
        
        // Marges
        $pdf->SetMargins(15, 15, 15);
        $pdf->SetHeaderMargin(5);
        $pdf->SetFooterMargin(10);
        
        $pdf->AddPage();
        
        // En-tête
        $pdf->SetFont('helvetica', 'B', 16);
        $pdf->Cell(0, 10, 'ADVANCED Corporate Services', 0, 1, 'C');
        $pdf->SetFont('helvetica', '', 12);
        $pdf->Cell(0, 10, '32 rue du Cure L-1368 Luxembourg', 0, 1, 'C');
        $pdf->Cell(0, 10, 'Bulletin de salaire - ' . $payslipData['period'], 0, 1, 'C');
        
        // Informations employé
        $pdf->SetFont('helvetica', 'B', 12);
        $pdf->Cell(0, 10, 'Informations employé', 0, 1);
        $pdf->SetFont('helvetica', '', 10);
        
        $employeeInfo = [
            'Nom' => $payslipData['employee_name'],
            'Matricule' => $payslipData['matricule'],
            'Période' => $payslipData['period'],
            'Profession' => $payslipData['profession']
        ];
        
        foreach ($employeeInfo as $label => $value) {
            $pdf->Cell(50, 7, $label, 0, 0);
            $pdf->Cell(0, 7, $value, 0, 1);
        }
        
        // Détails du salaire
        $pdf->Ln(5);
        $pdf->SetFont('helvetica', 'B', 12);
        $pdf->Cell(0, 10, 'Détails du salaire', 0, 1);
        $pdf->SetFont('helvetica', '', 10);
        
        // Tableau des gains
        $pdf->SetFillColor(240, 240, 240);
        $pdf->Cell(100, 7, 'Libellé', 1, 0, 'L', true);
        $pdf->Cell(40, 7, 'Taux', 1, 0, 'R', true);
        $pdf->Cell(40, 7, 'Montant', 1, 1, 'R', true);
        
        $pdf->Cell(100, 7, 'Salaire de base', 1, 0);
        $pdf->Cell(40, 7, '', 1, 0);
        $pdf->Cell(40, 7, number_format($payslipData['gross_salary'], 2) . ' €', 1, 1, 'R');
        
        // Cotisations sociales
        foreach ($payslipData['social_charges'] as $charge) {
            $pdf->Cell(100, 7, $charge['label'], 1, 0);
            $pdf->Cell(40, 7, $charge['rate'] . '%', 1, 0, 'R');
            $pdf->Cell(40, 7, number_format($charge['amount'], 2) . ' €', 1, 1, 'R');
        }
        
        // Total brut
        $pdf->SetFont('helvetica', 'B', 10);
        $pdf->Cell(140, 7, 'Total brut imposable', 1, 0, 'R');
        $pdf->Cell(40, 7, number_format($payslipData['taxable_gross'], 2) . ' €', 1, 1, 'R');
        
        // Impôt
        $pdf->Cell(140, 7, 'Impôt sur le revenu (' . $payslipData['tax_rate'] . '%)', 1, 0, 'R');
        $pdf->Cell(40, 7, number_format($payslipData['tax_amount'], 2) . ' €', 1, 1, 'R');
        
        // Net à payer
        $pdf->SetFont('helvetica', 'B', 12);
        $pdf->Cell(140, 10, 'Net à payer', 1, 0, 'R');
        $pdf->Cell(40, 10, number_format($payslipData['net_salary'], 2) . ' €', 1, 1, 'R');
        
        // Pied de page
        $pdf->SetY(-15);
        $pdf->SetFont('helvetica', 'I', 8);
        $pdf->Cell(0, 10, 'Généré le ' . date('d/m/Y H:i'), 0, 0, 'C');
        
        // Sauvegarde du PDF
        $filename = 'payslip_' . $payslipData['employee_id'] . '_' . str_replace('/', '-', $payslipData['period']) . '.pdf';
        $filepath = '/home/advanck/salaires//storage/payslips/' . $filename;
        
        $pdf->Output($filepath, 'F');
        
        return [
            'filename' => $filename,
            'filepath' => $filepath
        ];
    }
}
?>