<?php include 'header.php'; ?>

<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="h3 mb-0 text-gray-800">Mon Profil</h1>
        </div>
    </div>

    <?php if (isset($_SESSION['flash'])): ?>
        <div class="alert alert-<?= $_SESSION['flash']['type'] ?>">
            <?= $_SESSION['flash']['message'] ?>
            <?php unset($_SESSION['flash']); ?>
        </div>
    <?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Informations personnelles</h6>
        </div>
        <div class="card-body">
            <form action="/profile" method="POST">
                <input type="hidden" name="csrf_token" value="<?= Auth::generateCsrfToken() ?>">
                
                <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Nom d'utilisateur</label>
                    <div class="col-sm-9">
                        <p class="form-control-plaintext"><?= htmlspecialchars($user['username']) ?></p>
                    </div>
                </div>
                
                <div class="form-group row">
                    <label for="email" class="col-sm-3 col-form-label">Email *</label>
                    <div class="col-sm-9">
                        <input type="email" class="form-control" id="email" name="email" 
                            value="<?= htmlspecialchars($user['email']) ?>" required>
                    </div>
                </div>
                
                <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Rôle</label>
                    <div class="col-sm-9">
                        <p class="form-control-plaintext">
                            <?= ucfirst(str_replace('_', ' ', $user['user_roles'])) ?>
                        </p>
                    </div>
                </div>
                
                <hr>
                
                <h5 class="mb-4">Changer le mot de passe</h5>
                
                <div class="form-group row">
                    <label for="current_password" class="col-sm-3 col-form-label">Mot de passe actuel</label>
                    <div class="col-sm-9">
                        <input type="password" class="form-control" id="current_password" name="current_password">
                        <small class="form-text text-muted">Requis pour changer le mot de passe</small>
                    </div>
                </div>
                
                <div class="form-group row">
                    <label for="new_password" class="col-sm-3 col-form-label">Nouveau mot de passe</label>
                    <div class="col-sm-9">
                        <input type="password" class="form-control" id="new_password" name="new_password">
                        <small class="form-text text-muted">Minimum 8 caractères</small>
                    </div>
                </div>
                
                <div class="form-group row">
                    <label for="confirm_password" class="col-sm-3 col-form-label">Confirmation</label>
                    <div class="col-sm-9">
                        <input type="password" class="form-control" id="confirm_password" name="confirm_password">
                    </div>
                </div>
                
                <div class="form-group row">
                    <div class="col-sm-9 offset-sm-3">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Enregistrer les modifications
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<script>
// Validation côté client pour la confirmation du mot de passe
document.querySelector('form').addEventListener('submit', function(e) {
    const newPassword = document.getElementById('new_password').value;
    const confirmPassword = document.getElementById('confirm_password').value;
    
    if (newPassword && newPassword !== confirmPassword) {
        e.preventDefault();
        alert('Les nouveaux mots de passe ne correspondent pas');
    }
});
</script>