<?php
require_once '/home/advanck/salaires/config/database.php';
session_start();

if (!isset($_SESSION['user']['id'])) {
    header('Location: ../../login.php');
    exit();
}

?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Liste des employés</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-5">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2>Liste des employés</h2>
        <a href="create" class="btn btn-success">➕ Ajouter un employé</a>
    </div>

    <table class="table table-bordered table-hover table-striped">
        <thead class="table-dark">
            <tr>
                <th>Nom</th>
                <th>Matricule</th>
                <th>Date d'entrée</th>
                <th>Taux impôt (%)</th>
                <th>Statut</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php if (count($employees) === 0): ?>
            <tr>
                <td colspan="6" class="text-center">Aucun employé trouvé</td>
            </tr>
        <?php else: ?>
            <?php foreach ($employees as $emp): ?>
                <tr>
                    <td><?= htmlspecialchars($emp['last_name'] . ' ' . $emp['first_name']) ?></td>
                    <td><?= htmlspecialchars($emp['matricule']) ?></td>
                    <td><?= htmlspecialchars($emp['date_entree']) ?></td>
                    <td><?= htmlspecialchars($emp['taux_impot']) ?></td>
                    <td>
                        <span class="badge bg-<?= $emp['status'] === 'actif' ? 'success' : 'secondary' ?>">
                            <?= $emp['status'] ?>
                        </span>
                    </td>
                    <td>
                        <a href="edit?id=<?= $emp['id'] ?>" class="btn btn-sm btn-primary">✏️ Modifier</a>
                        <a href="delete?id=<?= $emp['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Supprimer cet employé ?')">🗑️ Supprimer</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
    </table>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
