<?php
namespace Controllers;

require_once '../models/SocialSettings.php';

use Models\SocialSettings;
use Utils\Auth;

class SocialController {
    private $socialSettings;
    private $moderationSettings;
    //private $appSetting;

    public function __construct() {
        $this->socialSettings = new SocialSettings();
    }
    private function loadInDashboard($viewFile, $data = []) {
        extract($data);
        $viewPath = __DIR__ . '/../views/settings/' . $viewFile;

        if (!file_exists($viewPath)) {
            throw new \Exception("Vue $viewFile introuvable");
        }

        $view = $viewPath;
        require __DIR__ . '/../views/dashboard.php';
    }
    
    public function social() {
        Auth::checkPermission(['admin', 'chef_comptable']);
        
        $socialSettings = SocialSettings::getAllSettings();
        
        //$settings = $this->socialSettings->findAll();
        //include '../views/settings/social.php';
        $this->loadInDashboard('social.php', $socialSettings);
    }

    public function moderation() {
        Auth::checkPermission(['admin', 'chef_comptable']);
        
        $moderationSettings = ModerationSettings::getAllSettings();
        
        //$settings = $this->socialSettings->findAll();
        //include '../views/settings/social.php';
        $this->loadInDashboard('moderation.php', $socialSettings);
    }
        // Ajouter un nouveau paramètre social
    public function add() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add'])) {
            $keyname = $_POST['keyname'];
            $value = $_POST['value'];
            $rate = $_POST['rate'];
            $gross_base = $_POST['gross_base'];

            // Ajouter le paramètre social via le modèle
            SocialSettings::addSetting($keyname, $value, $rate, $gross_base);
            header('Location: /settings');  // Redirection vers la liste des paramètres sociaux
            exit;
        }
    }
        // Mettre à jour un paramètre social existant
    public function update() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update'])) {
            $id = $_POST['id'];
            $keyname = $_POST['keyname'];
            $value = $_POST['value'];
            $rate = $_POST['rate'];
            $gross_base = $_POST['gross_base'];

            // Mettre à jour le paramètre social via le modèle
            SocialSettings::updateSetting($id, $keyname, $value, $rate, $gross_base);
            header('Location: /settings');  // Redirection vers la liste des paramètres sociaux
            exit;
        }
    }
    // Supprimer un paramètre social
    public function delete() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete'])) {
            $id = $_POST['id'];

            // Supprimer le paramètre social via le modèle
            SocialSettings::deleteSetting($id);
            header('Location: /settings');  // Redirection vers la liste des paramètres sociaux
            exit;
        }
    }

    private function updateSocialSettings() {
        $data = [
            'CM' => ['rate' => $_POST['cm_rate'], 'gross_base' => $_POST['cm_base']],
            'CME' => ['rate' => $_POST['cme_rate'], 'gross_base' => $_POST['cme_base']],
            'CP' => ['rate' => $_POST['cp_rate'], 'gross_base' => $_POST['cp_base']],
            'SD' => ['rate' => $_POST['sd_rate'], 'gross_base' => $_POST['sd_base']]
        ];

        if ($this->socialSettings->updateAll($data)) {
            $_SESSION['flash'] = ['type' => 'success', 'message' => 'Paramètres sociaux mis à jour'];
        } else {
            $_SESSION['flash'] = ['type' => 'error', 'message' => 'Erreur lors de la mise à jour'];
        }
    }

    // Méthodes pour appSettings et taxSettings similaires...
}
?>