<?php
namespace Controllers;
// /home/advanck/salaires/controllers/DashboardController.php

require_once __DIR__.'/../models/Employee.php';
require_once __DIR__.'/../models/Payslip.php';
require_once __DIR__.'/../models/User.php';
require_once __DIR__.'/../models/ActivityLog.php';

use Models\Employee;
use Models\Payslip;
use Models\User;
// require_once ROOT_PATH . '/utils/Auth.php';
use Utils\Auth;
use Controllers\ActivityLogController;
use Models\ActivityLog;


class EmployeeDashboardController {
    private $employeeModel;
    private $payslipModel;
    private $userModel;

     public function __construct() {
        $this->employeeModel = new Employee();
        $this->payslipModel = new Payslip();
        $this->userModel = new User();
    }

    public function index() {
        // Test forcé
        if (!class_exists('Utils\Auth')) {
            die("ERREUR: La classe Auth n'est toujours pas chargée. Dernier chemin: " 
                . __DIR__ . '/../utils/Auth.php');
        }
        $activityLog = new \Models\ActivityLog();

        // Vérifier l'authentification
        Auth::checkPermission(['admin', 'chef_comptable', 'comptable']);

        // Récupération de la dernière date
        $lastActivityDate = $activityLog->getLastDate($_SESSION['user_id'] ?? null);

        // Récupérer les données pour le dashboard
        $data = [
            'status_counts' => $this->employeeModel->statusCount(),
            'total_salary' => $this->payslipModel->getNetTotalForMonth(),
            'stats' => $this->payslipModel->getNetTotalFor6Months()
        ];
        extract($data); // Convertit les clés du tableau en variables
        // Charger la vue
        $this->loadInDashboard('dashboard.php', $data);
    }
    private function loadInDashboard($viewFile, $data = []) {
        // Si $data n'est pas vide, extraire les variables du tableau
        if (!empty($data)) {
            extract($data); // Convertit les clés du tableau en variables
        }
        $viewPath = __DIR__ . '/../views/employees/' . $viewFile;

        if (!file_exists($viewPath)) {
            throw new \Exception("Vue $viewFile introuvable");
        }

        $view = $viewPath;
        require __DIR__ . '/../views/dashboard.php';
    }
    /* public function view(){
        // Récupérer les données pour le dashboard
        $data = [
            'employees' => $this->employeeModel->viewEmployees()
        ];
        extract($data); // Convertit les clés du tableau en variables
        $this->loadInDashboard('index.php');
    } */
}
?>